/*
 * Decompiled with CFR 0.152.
 */
package dev.satyrn.wolfarmor.entity.ai;

import dev.satyrn.wolfarmor.WolfArmorMod;
import dev.satyrn.wolfarmor.api.entity.passive.IArmoredWolf;
import dev.satyrn.wolfarmor.api.util.CreatureFoodStats;
import dev.satyrn.wolfarmor.common.network.packets.WolfEatMessage;
import dev.satyrn.wolfarmor.common.network.packets.WolfHealMessage;
import dev.satyrn.wolfarmor.config.WolfArmorConfig;
import dev.satyrn.wolfarmor.util.WolfFoodStatsLevel;
import java.util.Comparator;
import javax.annotation.Nonnull;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.IInventoryChangedListener;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;

public class EntityAIWolfEatFromPack
extends EntityAIBase
implements IInventoryChangedListener {
    private final EntityWolf entity;
    private final IArmoredWolf armoredWolf;
    private final NonNullList<ItemStack> inventoryContents = NonNullList.func_191196_a();
    private final WolfArmorConfig config;
    private final SimpleNetworkWrapper connection;
    private ItemStack eatingFood = ItemStack.field_190927_a;
    private int eatCooldown;
    private int foodEatTime;
    private boolean hasHealedSinceLastReset;

    public EntityAIWolfEatFromPack(@Nonnull EntityWolf entity) {
        this.entity = entity;
        this.armoredWolf = (IArmoredWolf)entity;
        this.config = WolfArmorMod.getConfig();
        this.connection = WolfArmorMod.getNetworkChannel();
        this.inventoryInit();
    }

    private void inventoryInit() {
        this.armoredWolf.getInventory().func_110132_b((IInventoryChangedListener)this);
        this.armoredWolf.getInventory().func_110134_a((IInventoryChangedListener)this);
        this.refreshInventoryContents((IInventory)this.armoredWolf.getInventory());
    }

    public boolean func_75250_a() {
        return !this.entity.func_190530_aW() && this.entity.field_70737_aN == 0 && this.config.getChestEnabled() && this.config.getAutoHealEnabled() && this.armoredWolf.getHasChest();
    }

    public void func_75249_e() {
        ItemStack mostEfficientFood;
        if (this.eatCooldown <= 0 && !(mostEfficientFood = this.getMostEfficientFood()).func_190926_b() && mostEfficientFood.func_77973_b() instanceof ItemFood) {
            boolean wasteNotWantNot;
            ItemFood foodItem = (ItemFood)mostEfficientFood.func_77973_b();
            float damageAmount = this.entity.func_110138_aP() - this.entity.func_110143_aJ();
            float healedAmount = foodItem.func_150905_g(mostEfficientFood);
            CreatureFoodStats foodStats = this.config.getFoodStatsLevel() != WolfFoodStatsLevel.DISABLED ? this.armoredWolf.getFoodStats() : null;
            boolean isHurtOrHungry = damageAmount >= 1.0f || foodStats != null && foodStats.needFood();
            boolean bl = wasteNotWantNot = healedAmount <= damageAmount || foodStats != null && healedAmount <= (float)(20 - foodStats.getFoodLevel());
            if (isHurtOrHungry && wasteNotWantNot) {
                this.eatingFood = mostEfficientFood;
                foodItem.getClass();
                this.foodEatTime = 32;
                this.eatCooldown = this.foodEatTime + this.entity.func_70681_au().nextInt(this.foodEatTime);
            }
        }
    }

    public boolean func_75253_b() {
        return this.eatCooldown > 0;
    }

    public void func_75246_d() {
        --this.eatCooldown;
        if (!this.eatingFood.func_190926_b() && this.eatingFood.func_77973_b() instanceof ItemFood) {
            if (this.foodEatTime > 0) {
                if (--this.foodEatTime % 4 == 0) {
                    NetworkRegistry.TargetPoint targetPoint = new NetworkRegistry.TargetPoint(this.entity.field_71093_bK, this.entity.field_70165_t, this.entity.field_70163_u, this.entity.field_70161_v, 80.0);
                    this.connection.sendToAllAround((IMessage)new WolfEatMessage(this.entity.func_145782_y(), this.eatingFood), targetPoint);
                    this.entity.func_184185_a(SoundEvents.field_187537_bA, 0.5f, (this.entity.func_70681_au().nextFloat() - this.entity.func_70681_au().nextFloat()) * 0.2f + 1.0f);
                }
            } else if (!this.hasHealedSinceLastReset) {
                CreatureFoodStats foodStats = this.armoredWolf.getFoodStats();
                boolean creatureFoodStatsEnabled = this.config.getFoodStatsLevel() != WolfFoodStatsLevel.DISABLED;
                this.hasHealedSinceLastReset = true;
                NetworkRegistry.TargetPoint targetPoint = new NetworkRegistry.TargetPoint(this.entity.field_71093_bK, this.entity.field_70165_t, this.entity.field_70163_u, this.entity.field_70161_v, 80.0);
                this.connection.sendToAllAround((IMessage)new WolfHealMessage(this.entity.func_145782_y()), targetPoint);
                if (creatureFoodStatsEnabled) {
                    foodStats.addStats((ItemFood)this.eatingFood.func_77973_b(), this.eatingFood);
                } else {
                    this.entity.func_70691_i((float)((ItemFood)this.eatingFood.func_77973_b()).func_150905_g(this.eatingFood));
                }
                this.eatingFood.func_190918_g(1);
            }
        }
    }

    public void func_75251_c() {
        this.foodEatTime = 0;
        this.hasHealedSinceLastReset = false;
        this.eatingFood = ItemStack.field_190927_a;
        this.inventoryInit();
    }

    public void func_76316_a(@Nonnull IInventory invBasic) {
        this.refreshInventoryContents(invBasic);
    }

    private void refreshInventoryContents(IInventory invBasic) {
        this.inventoryContents.clear();
        for (int slotIndex = 1; slotIndex < 1 + this.armoredWolf.getMaxSizeInventory() - 1; ++slotIndex) {
            this.inventoryContents.add((Object)invBasic.func_70301_a(slotIndex));
        }
    }

    @Nonnull
    private ItemStack getMostEfficientFood() {
        float healthDiff = this.entity.func_110138_aP() - this.entity.func_110143_aJ();
        return this.inventoryContents.stream().filter(itemStack -> !itemStack.func_190926_b() && this.entity.func_70877_b(itemStack) && itemStack.func_77973_b() instanceof ItemFood).min(Comparator.comparing(itemStack -> {
            ItemFood food = (ItemFood)itemStack.func_77973_b();
            return Float.valueOf(Math.abs(healthDiff - (float)food.func_150905_g(itemStack)));
        })).orElse(ItemStack.field_190927_a);
    }
}

